	.MODEL	LARGE,C
	.CODE
;
dsaddr0	dw	0		; C ds
sssave0	dw	0
spsave0	dw	0
rcvr0	dd	0		; C receiver()
stck0	dd	0		; stack for receiver()
;
dsaddr1	dw	0		; C ds
sssave1	dw	0
spsave1	dw	0
rcvr1	dd	0		; C receiver()
stck1	dd	0		; stack for receiver()
;
dsaddr2	dw	0		; C ds
sssave2	dw	0
spsave2	dw	0
rcvr2	dd	0		; C receiver()
stck2	dd	0		; stack for receiver()
;
dsaddr3	dw	0		; C ds
sssave3	dw	0
spsave3	dw	0
rcvr3	dd	0		; C receiver()
stck3	dd	0		; stack for receiver()
;
; pkset (int portno, void (far *receiver)(), int far *stk)
;	receiver: C receiver function address
;	stk:      top (NOT start) of stack address
;
	public	pkset
pkset	label	far
portno	EQU	WORD PTR[BP+6]
coff	EQU	WORD PTR[BP+8]
cseg	EQU	WORD PTR[BP+10]
soff	EQU	WORD PTR[BP+12]
sseg	EQU	WORD PTR[BP+14]
;
	push	bp
	mov	bp,sp
;
	mov	ax,portno
	cmp	ax,0
	je	set0
	cmp	ax,1
	je	set1
	cmp	ax,2
	je	set2
	cmp	ax,3
	je	set3
	jmp	setret
;
set0:
	mov	ax,coff				; receiver address
	mov	word ptr cs:rcvr0,ax
	mov	ax,cseg
	mov	word ptr cs:rcvr0+2,ax
	mov	ax,soff				; stack address
	mov	word ptr cs:stck0,ax
	mov	ax,sseg
	mov	word ptr cs:stck0+2,ax
	mov	word ptr cs:dsaddr0,ds		; ds
	jmp	SHORT setret
;
set1:
	mov	ax,coff				; receiver address
	mov	word ptr cs:rcvr1,ax
	mov	ax,cseg
	mov	word ptr cs:rcvr1+2,ax
	mov	ax,soff				; stack address
	mov	word ptr cs:stck1,ax
	mov	ax,sseg
	mov	word ptr cs:stck1+2,ax
	mov	word ptr cs:dsaddr1,ds		; ds
	jmp	SHORT setret
;
set2:
	mov	ax,coff				; receiver address
	mov	word ptr cs:rcvr2,ax
	mov	ax,cseg
	mov	word ptr cs:rcvr2+2,ax
	mov	ax,soff				; stack address
	mov	word ptr cs:stck2,ax
	mov	ax,sseg
	mov	word ptr cs:stck2+2,ax
	mov	word ptr cs:dsaddr2,ds		; ds
	jmp	SHORT setret
;
set3:
	mov	ax,coff				; receiver address
	mov	word ptr cs:rcvr3,ax
	mov	ax,cseg
	mov	word ptr cs:rcvr3+2,ax
	mov	ax,soff				; stack address
	mov	word ptr cs:stck3,ax
	mov	ax,sseg
	mov	word ptr cs:stck3+2,ax
	mov	word ptr cs:dsaddr3,ds		; ds
	jmp	SHORT setret
;
setret:
	mov	sp,bp
	pop	bp
	retf
;
; pkint0/1/2/3 - Packet driver receive call handlers
;
	public	pkint0
pkint0	label	far
	pushf					; save his interrupt state
	cli					; no distractions
	mov	cs:sssave0,ss			; save my stack
	mov	cs:spsave0,sp
	mov	sp,word ptr cs:stck0		; load C stack
	mov	ss,word ptr cs:stck0+2
;
	push	es	; push regs, making them available to receiver ()
	push	ds
	push	ax
	push	bx
	push	cx
	push	dx
	push	bp
	push	si
	push	di
	mov	ax,0
	push	ax
;
	mov	ds,cs:dsaddr0			; load C ds
	call	cs:[rcvr0]
;
	pop	ax				; dump device #
	pop	di				; pop args
	pop	si
	pop	bp
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	ds
	pop	es
	mov	ss,cs:sssave0			; restore my stack
	mov	sp,cs:spsave0
	popf
	retf
;
	public	pkint1
pkint1	label	far
	pushf					; save his interrupt state
	cli					; no distractions
	mov	cs:sssave1,ss			; save my stack
	mov	cs:spsave1,sp
	mov	sp,word ptr cs:stck1		; load C stack
	mov	ss,word ptr cs:stck1+2
;
	push	es	; push regs, making them available to receiver ()
	push	ds
	push	ax
	push	bx
	push	cx
	push	dx
	push	bp
	push	si
	push	di
	mov	ax,1
	push	ax
;
	mov	ds,cs:dsaddr1			; load C ds
	call	cs:[rcvr1]
;
	pop	ax				; dump device #
	pop	di				; pop args
	pop	si
	pop	bp
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	ds
	pop	es
	mov	ss,cs:sssave1			; restore my stack
	mov	sp,cs:spsave1
	popf
	retf
;
	public	pkint2
pkint2	label	far
	pushf					; save his interrupt state
	cli					; no distractions
	mov	cs:sssave2,ss			; save my stack
	mov	cs:spsave2,sp
	mov	sp,word ptr cs:stck2		; load C stack
	mov	ss,word ptr cs:stck2+2
;
	push	es	; push regs, making them available to receiver ()
	push	ds
	push	ax
	push	bx
	push	cx
	push	dx
	push	bp
	push	si
	push	di
	mov	ax,2
	push	ax
;
	mov	ds,cs:dsaddr2			; load C ds
	call	cs:[rcvr2]
;
	pop	ax				; dump device #
	pop	di				; pop args
	pop	si
	pop	bp
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	ds
	pop	es
	mov	ss,cs:sssave2			; restore my stack
	mov	sp,cs:spsave2
	popf
	retf
;
	public	pkint3
pkint3	label	far
	pushf					; save his interrupt state
	cli					; no distractions
	mov	cs:sssave3,ss			; save my stack
	mov	cs:spsave3,sp
	mov	sp,word ptr cs:stck3		; load C stack
	mov	ss,word ptr cs:stck3+2

;
	push	es	; push regs, making them available to receiver ()
	push	ds
	push	ax
	push	bx
	push	cx
	push	dx
	push	bp
	push	si
	push	di
	mov	ax,3
	push	ax
;
	mov	ds,cs:dsaddr3			; load C ds
	call	cs:[rcvr3]
;
	pop	ax				; dump device #
	pop	di				; pop args
	pop	si
	pop	bp
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	ds
	pop	es
	mov	ss,cs:sssave3			; restore my stack
	mov	sp,cs:spsave3
	popf
	retf
;
; pksende - Packet driver as_send_pkt() upcall (ETHERNET)
;
;buffer available upcall:
;	(*upcall)(buffer, result)
;		int	result;         AX	/* 0 for copy ok */
;		char far *buffer;	ES:DI	/* from as_send_pkt() call */
;
	public	pksende
pksende	label	far
;
	cmp	ax,0
	jz	pksende1
	mov	byte ptr es:[di+16],0ffH	; mark packet as 'send fail'
	jmp	short pksende2
pksende1:
	mov	byte ptr es:[di+16],000H	; mark packet as 'send ok'
pksende2:
;
	retf
;
;
;
; pksends - Packet driver as_send_pkt() upcall (SLIP)
;
;buffer available upcall:
;	(*upcall)(buffer, result)
;		int	result;         AX	/* 0 for copy ok */
;		char far *buffer;	ES:DI	/* from as_send_pkt() call */
;
	public	pksends
pksends	label	far
;
	cmp	ax,0
	jz	pksends1
	mov	byte ptr es:[di],0ffH		; mark packet as 'send fail'
	jmp	short pksends2
pksends1:
	mov	byte ptr es:[di],000H		; mark packet as 'send ok'
pksends2:
;
	retf
;
	end
