/* --------------------------------- term.c --------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* shutdown code.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "fly.h"

static char * FAR
lfrac (long a, long b)
{
	int		s, f;
	long		l;
	static char	buf[20];

	if (a < 0x7fffffffL/100L)
		l = a * 100L / b;
	else if (b >= 100L)
		l = a / (b / 100L);
	else
		return ("999.99");
	if (l) {
		if ((s = l < 0)) {
			f = (int)((-l)%100);
			l = -((-l)/100L);
		} else {
			f = (int)(l%100);
			l = l/100L;
		}
		if (s && !l)
			sprintf (buf, "  -0.%02d", f);
		else
			sprintf (buf, "%4ld.%02d", l, f);
		return (buf);
	} else
		return ("0");
}

extern void FAR
terminate (int StackUsed)
{
	Ulong	lt;

	st.flags &= ~SF_INITED;

	if (Tm) {
		lt = st.present / 1000L;
		LogPrintf ("Time     %lu:%02lu\n", lt/60L, lt%60L);
	}
	if (st.stats[31]) {
		LogPrintf ("nFrames  %lu\n", st.stats[31]);
		LogPrintf ("Elapsed  %s\n", lfrac (st.stats[32], st.stats[31]));
		LogPrintf ("Video    %s\n", lfrac (st.stats[33], st.stats[31]));
		LogPrintf ("3D       %s\n", lfrac (st.stats[34], st.stats[31]));
		LogPrintf ("2D       %s\n", lfrac (st.stats[36], st.stats[31]));
		LogPrintf ("Simulate %s\n", lfrac (st.stats[35], st.stats[31]));
		LogPrintf ("PageFlip %s\n", lfrac (st.stats[37], st.stats[31]));
		LogPrintf ("Balance  %s\n", lfrac (st.stats[32]-st.stats[33]
			-st.stats[34]-st.stats[35]-st.stats[36]-st.stats[37], st.stats[31]));
	}

	remote_term ();

	if (CC)
		LogPrintf ("score    %u\n", (int)CC->score);

	CV = CC = 0;
	list_clear (&CO);
	land_term ();

	LogPrintf ("bullets  %lu\n", st.nbullets);
	LogPrintf ("last obj %lu\n", st.object_id);

	bodies_term ();

	buffers_free ();

	pointers_term ();

	term_funcs ();

	if (Snd) {
		Snd->Term ();
		sound_term ();
		Snd = 0;
	}

	mac_term ();

	if (Kbd) {
		Kbd->Term ();
		keyboard_term ();
		Kbd = 0;
	}

	DEL0 (CW);
	DEL0 (CP);
	if (CS) {
		if (CS->device) {
			if (Gr) {
				if (st.misc[7])
					Gr->Shutters (-2);	/* turn off */

				if (CT) {
				    Gr->CloseTextWindow (CT);
				    DEL0 (CT);
				}
				Gr->Term (CS->device);
			}
			CS->device = 0;
		}
		DEL0 (CS);
	}

	windows_term ();

	devices_term ();
	Gr = 0;

	st.pname = xfree (st.pname);
	st.dname = xfree (st.dname);
	st.fname = xfree (st.fname);
	st.vname = xfree (st.vname);
	st.iname = xfree (st.iname);
	st.mname = xfree (st.mname);
	st.nikname = xfree (st.nikname);
	st.vmdname = xfree (st.vmdname);
	st.ptype = xfree (st.ptype);
	st.dtype = xfree (st.dtype);
	st.lname = xfree (st.lname);

	if (st.netnames) {
		struct netname	*nn;

		for (nn = st.netnames; nn;) {
			xfree (nn->name);
			nn = DEL (nn);
		}
	}

	if (st.flags & SF_SKY)
		sky_term ();

	msg_term ();

	memory_term ();

	LogPrintf ("fly8 end: %s\n", Tm->Ctime ());

	if (Tm) {
		Tm->Term ();
		Tm = 0;
	}

	if (Sys) {
		Sys->Term ();
		Sys = 0;
	}

	LogPrintf ("stack used: %d bytes\n", StackUsed);

	log_term ();
}

extern void FAR
die (void)
{
	st.flags &= ~(SF_INITED|SF_INTERACTIVE);
	LogPrintf ("Aborting...\n");
	terminate (0);
	exit (1);
}
