/* --------------------------------- timer.c -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* High resolution time services directly reading the 8254.
*/

#include <stdio.h>
#include <string.h>
#include <time.h>

#include "fly.h"
#include "tick.h"

static Ulong FAR
timer_milli (void)
{
	static Ulong	days = 0, last = 0;
	register Ulong	t;

	if ((t = GetLowTickCount ()) < last)
		days += 24L*60L*60L*1000L;
	last = t;

#if TICKSPSEC > 1000
	return (days + t / (TICKSPSEC/1000));
#else
	return (days + t * (1000/TICKSPSEC));
#endif
}

static int FAR
timer_hires (void)		/* get fastest timer available */
{
	return (GetTimer ());
}

static int FAR
timer_init (void)
{
	return (0);
}

static void FAR
timer_term (void)
{
	return;
}

static char * FAR
timer_ctime (void)
{
	time_t	tm;
	char	*t;
	int	bug;

	tm = time (0);
	t = ctime (&tm);
	bug = strlen (t);	/* micro&soft hits again! */
	t[bug - 1] = '\0';	/* kill NewLine */
	return (t);
}

extern struct TmDriver TmDriver = {
	"PC8254",
	0,
	timer_init,
	timer_term,
	timer_milli,
	timer_hires,
	timer_ctime
};
